/*
 * Decompiled with CFR 0.152.
 */
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class OggPlayer {
    private OggClip ogg;
    private float volume = 0.9f;
    static final String musicFolder = "file/";
    static final String[] musiclist;

    static {
        String[] stringArray = new String[16];
        stringArray[0] = "pengsogn.ogg";
        stringArray[2] = "pengsogn2.ogg";
        stringArray[4] = "pengsogn3.ogg";
        stringArray[6] = "pengsogn4.ogg";
        stringArray[8] = "pengreverse.ogg";
        stringArray[10] = "KCUFO.ogg";
        stringArray[12] = "sound.ogg";
        stringArray[14] = "panpeng.ogg";
        musiclist = stringArray;
    }

    public OggPlayer(int songNumb) {
        try {
            this.ogg = new OggClip("file/pengsogn.ogg");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void play(int songNumb) {
        this.ogg.stop();
        this.loadSongs(songNumb);
        this.ogg.loop();
        this.ogg.setGain(this.volume);
    }

    public void pauseResume() {
        if (this.ogg.isPaused()) {
            this.ogg.resume();
        } else {
            this.ogg.pause();
        }
    }

    public void stop() {
        this.ogg.stop();
    }

    public boolean isPaused() {
        return this.ogg.isPaused();
    }

    private void loadSongs(int songNumb) {
        String[] songs = this.getSongs(songNumb);
        if (songs[1] == null) {
            try {
                this.ogg.changeSongs(musicFolder + songs[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.ogg.changeSongs(musicFolder + songs[0], musicFolder + songs[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getSongs(int songNumb) {
        return new String[]{musiclist[2 * songNumb], musiclist[2 * songNumb + 1]};
    }

    private class OggClip {
        private final int BUFSIZE = 8192;
        private int convsize = 16384;
        private byte[] convbuffer = new byte[this.convsize];
        private SyncState oy;
        private StreamState os;
        private Page og;
        private Packet op;
        private Info vi;
        private Comment vc;
        private DspState vd;
        private Block vb;
        private SourceDataLine outputLine;
        private int rate;
        private int channels;
        private BufferedInputStream bitStream = null;
        private BufferedInputStream bitStreamIntro = null;
        private byte[] buffer = null;
        private int bytes = 0;
        private Thread player = null;
        private float balance;
        private float gain = -1.0f;
        private boolean paused;
        private float oldGain;

        public OggClip(String ref, String ref2) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            File f2 = new File(ref2);
            FileInputStream in2 = new FileInputStream(f2);
            try {
                this.init(in, in2);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public OggClip(String ref) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            try {
                this.init(in, null);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public OggClip(InputStream in) throws IOException {
            this.init(in, null);
        }

        public void changeSongs(String ref, String ref2) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            File f2 = new File(ref2);
            FileInputStream in2 = new FileInputStream(f2);
            try {
                this.init(in, in2);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public void changeSongs(String ref) throws IOException {
            File f = new File(ref);
            FileInputStream in = new FileInputStream(f);
            try {
                this.init(in, null);
            }
            catch (IOException e) {
                throw new IOException("Couldn't find: " + ref);
            }
        }

        public void setDefaultGain() {
            this.setGain(-1.0f);
        }

        public void setGain(float gain) {
            if (gain != -1.0f && (gain < 0.0f || gain > 1.0f)) {
                throw new IllegalArgumentException("Volume must be between 0.0 and 1.0");
            }
            this.gain = gain;
            if (this.outputLine == null) {
                return;
            }
            try {
                FloatControl control = (FloatControl)this.outputLine.getControl(FloatControl.Type.MASTER_GAIN);
                if (gain == -1.0f) {
                    control.setValue(0.0f);
                } else {
                    float max = control.getMaximum();
                    float min = control.getMinimum();
                    float range = max - min;
                    control.setValue(min + range * gain);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }

        public void setBalance(float balance) {
            this.balance = balance;
            if (this.outputLine == null) {
                return;
            }
            try {
                FloatControl control = (FloatControl)this.outputLine.getControl(FloatControl.Type.BALANCE);
                control.setValue(balance);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkState() {
            while (this.paused && this.player != null) {
                Thread thread = this.player;
                synchronized (thread) {
                    if (this.player != null) {
                        try {
                            this.player.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.stopped();
        }

        public void pause() {
            this.paused = true;
            this.oldGain = this.gain;
            this.setGain(0.0f);
        }

        public boolean isPaused() {
            return this.paused;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            if (!this.paused) {
                this.play();
                return;
            }
            this.paused = false;
            Thread thread = this.player;
            synchronized (thread) {
                if (this.player != null) {
                    this.player.notify();
                }
            }
            this.setGain(this.oldGain);
        }

        public boolean stopped() {
            return this.player == null || !this.player.isAlive();
        }

        private void init(InputStream in, InputStream inIntro) throws IOException {
            if (in == null) {
                throw new IOException("Couldn't find input source");
            }
            this.bitStream = new BufferedInputStream(in);
            this.bitStream.mark(Integer.MAX_VALUE);
            if (inIntro != null) {
                this.bitStreamIntro = new BufferedInputStream(inIntro);
                this.bitStreamIntro.mark(Integer.MAX_VALUE);
            } else {
                this.bitStreamIntro = null;
            }
        }

        public void play() {
            this.stop();
            try {
                this.bitStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.player = new Thread(){

                @Override
                public void run() {
                    try {
                        OggClip.this.playStream(Thread.currentThread(), OggClip.this.bitStream);
                    }
                    catch (InternalException e) {
                        e.printStackTrace();
                    }
                    try {
                        OggClip.this.bitStream.reset();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.player.setDaemon(true);
            this.player.start();
        }

        public void loop() {
            this.stop();
            try {
                if (this.bitStreamIntro != null) {
                    this.bitStreamIntro.reset();
                }
                this.bitStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.player = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    if (OggClip.this.bitStreamIntro != null) {
                        try {
                            OggClip.this.playStream(Thread.currentThread(), OggClip.this.bitStreamIntro);
                        }
                        catch (InternalException e) {
                            e.printStackTrace();
                            OggClip.this.player = null;
                        }
                    }
                    while (OggClip.this.player == Thread.currentThread()) {
                        try {
                            OggClip.this.playStream(Thread.currentThread(), OggClip.this.bitStream);
                        }
                        catch (InternalException e) {
                            e.printStackTrace();
                            OggClip.this.player = null;
                        }
                        try {
                            OggClip.this.bitStream.reset();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.player.setDaemon(true);
            this.player.start();
        }

        public void stop() {
            if (this.stopped()) {
                return;
            }
            this.setGain(0.0f);
            this.player = null;
        }

        public void close() {
            try {
                if (this.bitStream != null) {
                    this.bitStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void initJavaSound(int channels, int rate) {
            try {
                AudioFormat audioFormat = new AudioFormat(rate, 16, channels, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new Exception("Line " + info + " not supported.");
                }
                try {
                    this.outputLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.outputLine.open(audioFormat);
                }
                catch (LineUnavailableException ex) {
                    throw new Exception("Unable to open the sourceDataLine: " + ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Illegal Argument: " + ex);
                }
                this.rate = rate;
                this.channels = channels;
                this.setBalance(this.balance);
                this.setGain(this.gain);
            }
            catch (Exception ee) {
                System.out.println(ee);
            }
        }

        private SourceDataLine getOutputLine(int channels, int rate) {
            if (this.outputLine == null || this.rate != rate || this.channels != channels) {
                if (this.outputLine != null) {
                    this.outputLine.drain();
                    this.outputLine.stop();
                    this.outputLine.close();
                }
                this.initJavaSound(channels, rate);
                this.outputLine.start();
            }
            return this.outputLine;
        }

        private void initJOrbis() {
            this.oy = new SyncState();
            this.os = new StreamState();
            this.og = new Page();
            this.op = new Packet();
            this.vi = new Info();
            this.vc = new Comment();
            this.vd = new DspState();
            this.vb = new Block(this.vd);
            this.buffer = null;
            this.bytes = 0;
            this.oy.init();
        }

        /*
         * Unable to fully structure code
         */
        private void playStream(Thread me, BufferedInputStream bitStream) throws InternalException {
            chained = false;
            this.initJOrbis();
            while (true) {
                if (this.checkState()) {
                    return;
                }
                eos = false;
                index = this.oy.buffer(8192);
                this.buffer = this.oy.data;
                try {
                    this.bytes = bitStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    throw new InternalException(e);
                }
                this.oy.wrote(this.bytes);
                if (chained) {
                    chained = false;
                } else if (this.oy.pageout(this.og) != 1) {
                    if (this.bytes < 8192) break;
                    throw new InternalException("Input does not appear to be an Ogg bitstream.");
                }
                this.os.init(this.og.serialno());
                this.os.reset();
                this.vi.init();
                this.vc.init();
                if (this.os.pagein(this.og) < 0) {
                    throw new InternalException("Error reading first page of Ogg bitstream data.");
                }
                if (this.os.packetout(this.op) != 1) {
                    throw new InternalException("Error reading initial header packet.");
                }
                if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                    throw new InternalException("This Ogg bitstream does not contain Vorbis audio data.");
                }
                i = 0;
                ** GOTO lbl64
                {
                    if (this.checkState()) {
                        return;
                    }
                    result = this.oy.pageout(this.og);
                    if (result == 0) ** GOTO lbl53
                    if (result == 1) {
                        this.os.pagein(this.og);
                        while (i < 2) {
                            result = this.os.packetout(this.op);
                            if (result == 0) break;
                            if (result == -1) {
                                throw new InternalException("Corrupt secondary header.  Exiting.");
                            }
                            this.vi.synthesis_headerin(this.vc, this.op);
                            ++i;
                        }
                    }
                    do {
                        if (i < 2) continue block7;
lbl53:
                        // 2 sources

                        index = this.oy.buffer(8192);
                        this.buffer = this.oy.data;
                        try {
                            this.bytes = bitStream.read(this.buffer, index, 8192);
                        }
                        catch (Exception e) {
                            throw new InternalException(e);
                        }
                        if (this.bytes == 0 && i < 2) {
                            throw new InternalException("End of file before finding all Vorbis headers!");
                        }
                        this.oy.wrote(this.bytes);
lbl64:
                        // 2 sources

                    } while (i < 2);
                }
                this.convsize = 8192 / this.vi.channels;
                this.vd.synthesis_init(this.vi);
                this.vb.init(this.vd);
                _pcmf = new float[1][][];
                _index = new int[this.vi.channels];
                this.getOutputLine(this.vi.channels, this.vi.rate);
                ** GOTO lbl145
                {
                    block35: {
                        block36: {
                            if (this.player != me) {
                                return;
                            }
                            result = this.oy.pageout(this.og);
                            if (result == 0) ** GOTO lbl132
                            if (result == -1) break block35;
                            this.os.pagein(this.og);
                            if (this.og.granulepos() != 0L) break block36;
                            chained = true;
                            eos = true;
                            ** GOTO lbl132
                        }
                        block11: while (true) {
                            if (this.checkState()) {
                                return;
                            }
                            result = this.os.packetout(this.op);
                            if (result == 0) break;
                            if (result == -1) continue;
                            if (this.vb.synthesis(this.op) == 0) {
                                this.vd.synthesis_blockin(this.vb);
                            }
                            while (true) {
                                if ((samples = this.vd.synthesis_pcmout(_pcmf, _index)) > 0) ** break;
                                continue block11;
                                if (this.checkState()) {
                                    return;
                                }
                                pcmf = _pcmf[0];
                                bout = samples < this.convsize ? samples : this.convsize;
                                i = 0;
                                while (i < this.vi.channels) {
                                    ptr = i * 2;
                                    mono = _index[i];
                                    j = 0;
                                    while (j < bout) {
                                        val = (int)((double)pcmf[i][mono + j] * 32767.0);
                                        if (val > 32767) {
                                            val = 32767;
                                        }
                                        if (val < -32768) {
                                            val = -32768;
                                        }
                                        if (val < 0) {
                                            val |= 32768;
                                        }
                                        this.convbuffer[ptr] = (byte)val;
                                        this.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                        ptr += 2 * this.vi.channels;
                                        ++j;
                                    }
                                    ++i;
                                }
                                this.outputLine.write(this.convbuffer, 0, 2 * this.vi.channels * bout);
                                this.vd.synthesis_read(bout);
                            }
                            break;
                        }
                        if (this.og.eos() != 0) {
                            eos = true;
                        }
                    }
                    do {
                        if (!eos) continue block10;
lbl132:
                        // 3 sources

                        if (eos) continue;
                        index = this.oy.buffer(8192);
                        this.buffer = this.oy.data;
                        try {
                            this.bytes = bitStream.read(this.buffer, index, 8192);
                        }
                        catch (Exception e) {
                            throw new InternalException(e);
                        }
                        if (this.bytes == -1) break block10;
                        this.oy.wrote(this.bytes);
                        if (this.bytes != 0) continue;
                        eos = true;
lbl145:
                        // 4 sources

                    } while (!eos);
                }
                this.os.clear();
                this.vb.clear();
                this.vd.clear();
                this.vi.clear();
            }
            this.oy.clear();
        }

        private class InternalException
        extends Exception {
            private static final long serialVersionUID = -4629645608084271297L;

            public InternalException(Exception e) {
                super(e);
            }

            public InternalException(String msg) {
                super(msg);
            }
        }
    }
}

