/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ResourceManager {
    private HashMap<File, BufferedImage> imgMap = new HashMap();
    private HashMap<File, byte[]> pxaMap = new HashMap();

    ResourceManager() {
    }

    public void addImage(String srcFile, int filterType) {
        this.addImage(new File(srcFile), filterType);
    }

    public boolean addImage(File srcFile, int filterType) {
        boolean succ;
        block8: {
            srcFile = ResourceManager.checkBase(srcFile);
            succ = false;
            File imgFile = srcFile;
            if (!this.imgMap.containsKey(imgFile)) break block8;
            return true;
        }
        try {
            switch (filterType) {
                case 0: {
                    this.imgMap.put(srcFile, ImageIO.read(new FileInputStream(srcFile)));
                    break;
                }
                case 1: {
                    BufferedImage img = ImageIO.read(new FileInputStream(srcFile));
                    if (srcFile.getName().endsWith(".png")) {
                        this.imgMap.put(srcFile, this.magenta2Trans(img));
                        break;
                    }
                    this.imgMap.put(srcFile, this.black2Trans(img));
                }
            }
            succ = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            succ = false;
        }
        return succ;
    }

    public void reloadImage(String src, int filterType) {
        this.reloadImage(new File(src), filterType);
    }

    public void reloadImage(File srcFile, int filterType) {
        if (this.imgMap.containsKey(srcFile = ResourceManager.checkBase(srcFile))) {
            this.imgMap.get(srcFile).flush();
            this.imgMap.remove(srcFile);
        }
        this.addImage(srcFile, filterType);
    }

    public Graphics getImgGraphics(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key).getGraphics();
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return null;
    }

    public BufferedImage getImg(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key);
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return null;
    }

    public BufferedImage getImg(String key) {
        return this.getImg(new File(key));
    }

    public int getImgH(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key).getHeight();
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return -1;
    }

    public int getImgW(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key).getWidth();
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return -1;
    }

    private BufferedImage black2Trans(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 3);
        int y = 0;
        while (y < src.getHeight()) {
            int x = 0;
            while (x < src.getWidth()) {
                int px = src.getRGB(x, y);
                if (px == -16777216) {
                    dest.setRGB(x, y, 0);
                } else {
                    dest.setRGB(x, y, px);
                }
                ++x;
            }
            ++y;
        }
        return dest;
    }

    private BufferedImage magenta2Trans(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 3);
        int y = 0;
        while (y < src.getHeight()) {
            int x = 0;
            while (x < src.getWidth()) {
                int px = src.getRGB(x, y);
                if (px == -65281) {
                    dest.setRGB(x, y, 0);
                } else {
                    dest.setRGB(x, y, px);
                }
                ++x;
            }
            ++y;
        }
        return dest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] addPxa(File srcFile) {
        srcFile = ResourceManager.checkBase(srcFile);
        AbstractInterruptibleChannel inChan = null;
        if (this.pxaMap.containsKey(srcFile)) {
            return this.pxaMap.get(srcFile);
        }
        byte[] pxaArray = null;
        try {
            try {
                FileInputStream inStream = new FileInputStream(srcFile);
                inChan = inStream.getChannel();
                ByteBuffer pxaBuf = ByteBuffer.allocate(256);
                ((FileChannel)inChan).read(pxaBuf);
                inChan.close();
                inStream.close();
                pxaBuf.flip();
                pxaArray = pxaBuf.array();
                this.pxaMap.put(srcFile, pxaArray);
                return pxaArray;
            }
            catch (FileNotFoundException inStream) {
                if (inChan == null) return pxaArray;
                try {
                    inChan.close();
                    return pxaArray;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return pxaArray;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inChan == null) return pxaArray;
                try {
                    inChan.close();
                    return pxaArray;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return pxaArray;
            }
        }
        finally {
            if (inChan != null) {
                try {
                    inChan.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public byte[] addPxa(String src) {
        return this.addPxa(new File(src));
    }

    public byte[] getPxa(File srcFile) {
        srcFile = ResourceManager.checkBase(srcFile);
        return this.pxaMap.get(srcFile);
    }

    public byte[] getPxa(String src) {
        return this.getPxa(new File(src));
    }

    public void savePxa(File srcFile) {
        try {
            FileOutputStream out = new FileOutputStream(srcFile);
            FileChannel outChan = out.getChannel();
            ByteBuffer pxaBuf = ByteBuffer.wrap(this.getPxa(srcFile));
            outChan.write(pxaBuf);
            outChan.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void purge() {
        this.imgMap.clear();
        this.pxaMap.clear();
    }

    /*
     * Unable to fully structure code
     */
    public static File checkBase(File res) {
        if (res.exists()) {
            return res;
        }
        currentLoc = res.getParentFile();
        place = "/";
        if (currentLoc != null) ** GOTO lbl11
        return res;
lbl-1000:
        // 1 sources

        {
            place = "/" + currentLoc.getName() + place;
            if (currentLoc.getParentFile() == null) {
                return res;
            }
            currentLoc = currentLoc.getParentFile();
lbl11:
            // 2 sources

            ** while (!currentLoc.getName().equals((Object)"mod"))
        }
lbl12:
        // 1 sources

        currentLoc = currentLoc.getParentFile();
        currentLoc = currentLoc.getParentFile();
        target = new File((currentLoc = new File(currentLoc + "/base")) + place + res.getName());
        if (target.exists()) {
            return target;
        }
        return res;
    }
}

