/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SoundPlayer {
    static final int SOUNDCHANNELS = 16;
    static float volume = 100.0f;
    static final int NUMB_OF_SOUNDS = 1;
    String directory = "file/";
    private final String[] soundArray = new String[]{"ofuck.wav"};
    private boolean[] soundChannels = new boolean[24];
    private ArrayList<byte[]> sfxArray;
    private SoundThread soundThread;
    private ArrayList<PlaySound> soundThreads;
    private ArrayList<Vector2> playedThisFrame = new ArrayList();
    SourceDataLine[] lines;

    public SoundPlayer() {
        this.resetAllChannels();
        this.soundThreads = new ArrayList();
        this.soundThread = new SoundThread();
        this.soundThread.initSounds();
        this.loadAllSounds();
        this.soundThread.start();
        ByteArrayInputStream is = new ByteArrayInputStream(this.sfxArray.get(0));
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(is);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, stream.getFormat(), (int)(stream.getFrameLength() * (long)format.getFrameSize()));
            this.lines = new SourceDataLine[16];
            int i = 0;
            while (i < 16) {
                this.lines[i] = (SourceDataLine)AudioSystem.getLine(info);
                this.lines[i].open(stream.getFormat());
                this.lines[i].start();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAllSounds() {
        this.sfxArray = new ArrayList();
        int i = 0;
        while (i < 1) {
            try {
                this.sfxArray.add(SoundPlayer.getBytesFromFile(new File(String.valueOf(this.directory) + this.soundArray[i])));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            ++i;
        }
    }

    public void resetAllChannels() {
        int i = 0;
        while (i < 16) {
            this.soundChannels[i] = false;
            ++i;
        }
    }

    public void playSound(int soundNumb) {
        this.playSound(soundNumb, 0);
    }

    public void soundAI() {
        if (this.soundThread.isPlaying()) {
            return;
        }
        ArrayList<Vector2> S = new ArrayList<Vector2>(this.playedThisFrame);
        this.soundThread.playSounds(S);
        this.playedThisFrame = new ArrayList();
    }

    public void playSound(int soundNumb, int soundChannel) {
        for (Vector2 V : this.playedThisFrame) {
            if (V.x != soundNumb) continue;
            return;
        }
        while (soundChannel < 16) {
            if (!this.soundChannels[soundChannel]) {
                this.playedThisFrame.add(new Vector2(soundNumb, soundChannel));
                this.soundChannels[soundChannel] = true;
                return;
            }
            ++soundChannel;
        }
    }

    public void freeChannel(int soundChannel) {
        this.soundChannels[soundChannel] = false;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        FileInputStream is = new FileInputStream(file);
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public class PlaySound
    extends Thread {
        byte[] sound;
        boolean muted = false;
        float pan = 0.0f;
        private int soundNumb;
        private int channel;
        double seconds = 0.0;
        SourceDataLine line;
        boolean looped_forever = false;
        boolean playing = true;
        boolean started = false;
        int loop_times = 0;
        int loops_done = 0;

        public void setNumb(Vector2 s) {
            this.soundNumb = s.x;
            this.channel = s.y;
        }

        public void stopSound() {
            this.playing = false;
        }

        @Override
        public void run() {
            try {
                this.line = SoundPlayer.this.lines[this.channel];
                this.line.start();
                this.sound = (byte[])SoundPlayer.this.sfxArray.get(this.soundNumb);
                ByteArrayInputStream i = new ByteArrayInputStream(this.sound);
                AudioInputStream stream = AudioSystem.getAudioInputStream(i);
                AudioFormat format = stream.getFormat();
                FloatControl volume_control = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                volume_control.setValue((float)(Math.log(volume / 100.0f) / Math.log(10.0) * 20.0));
                BooleanControl mute_control = (BooleanControl)this.line.getControl(BooleanControl.Type.MUTE);
                mute_control.setValue(this.muted);
                int num_read = 0;
                byte[] buf = new byte[1000];
                while ((num_read = stream.read(buf, 0, buf.length)) >= 0 && this.playing) {
                    int offset = 0;
                    while (offset < num_read && this.playing) {
                        offset += this.line.write(buf, offset, num_read - offset);
                    }
                    this.started = true;
                }
                int k = 0;
                while (k < 50) {
                    if (!this.playing) break;
                    Thread.sleep(50L);
                    ++k;
                }
                this.line.flush();
                this.line.stop();
                i.close();
                stream.close();
                ((SoundPlayer)SoundPlayer.this).soundChannels[this.channel] = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class SoundThread
    extends Thread {
        private boolean play = false;
        private ArrayList<Vector2> sounds;
        private ArrayList<PlaySound> removeSounds;

        SoundThread() {
        }

        public void initSounds() {
            this.sounds = new ArrayList();
            this.removeSounds = new ArrayList();
        }

        public void playSounds(ArrayList<Vector2> soundlist) {
            if (soundlist.size() == 0) {
                return;
            }
            this.sounds = soundlist;
            this.play = true;
        }

        public boolean isPlaying() {
            return this.play;
        }

        @Override
        public void run() {
            while (true) {
                long beginTime = System.nanoTime();
                while (this.play) {
                    for (Vector2 I : this.sounds) {
                        boolean playSound = true;
                        for (PlaySound P : SoundPlayer.this.soundThreads) {
                            if (P.soundNumb != I.x) continue;
                            if (P.started) {
                                P.stopSound();
                                this.removeSounds.add(P);
                                continue;
                            }
                            playSound = false;
                        }
                        for (PlaySound P : this.removeSounds) {
                            SoundPlayer.this.soundThreads.remove(P);
                        }
                        if (!playSound) continue;
                        PlaySound Player = new PlaySound();
                        Player.setNumb(I);
                        Player.start();
                        SoundPlayer.this.soundThreads.add(Player);
                    }
                    this.sounds.clear();
                    this.play = false;
                    long l = System.nanoTime() - beginTime;
                }
                long timeTaken = System.nanoTime() - beginTime;
                long timeLeft = (166666666L - timeTaken) / 1000000L;
                if (timeLeft < 10L) {
                    timeLeft = 10L;
                }
                try {
                    Thread.sleep(timeLeft);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    class Vector2 {
        int x;
        int y;

        public Vector2(int x1, int y1) {
            this.x = x1;
            this.y = y1;
        }
    }
}

