/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2;

import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.Menu;
import ca.noxid.peng2.MenuItem;
import ca.noxid.peng2.ResourceManager;
import ca.noxid.peng2.battlers.PlayerChar;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;

public class BattleMenu
extends Menu {
    PlayerChar pc;
    int cursOffset;
    Font nameFont = new Font("monospaced", 1, 24);

    public void resetCursor() {
        this.cursOffset = 0;
        this.selection = 0;
    }

    @Override
    public void setOptions(List<MenuItem> opt) {
        super.setOptions(opt);
        this.resetCursor();
    }

    public BattleMenu(int x, int y, PlayerChar owner) {
        super(x, y, 0, 0);
        this.pc = owner;
    }

    @Override
    public void update(KeyUpdate update) {
        super.update(update);
        if (this.selection < this.cursOffset) {
            --this.cursOffset;
        }
        if (this.selection > this.cursOffset + 3) {
            ++this.cursOffset;
        }
    }

    @Override
    public void draw(Graphics g) {
        g.drawImage(ResourceManager.rm.getImg(ResourceManager.battlemenu), this.x, this.y, null);
        BufferedImage mp = ResourceManager.rm.getImg(ResourceManager.mpbar);
        g.setFont(this.nameFont);
        g.setColor(Color.white);
        g.drawString(this.pc.name, this.x + 10, this.y + 30);
        int mpBarLen = mp.getWidth();
        int displayLen = (int)((float)this.pc.mp / (float)this.pc.mpMax * (float)mpBarLen);
        g.drawImage(mp, this.x + 208, this.y + 31, this.x + 208 + displayLen, this.y + 31 + mp.getHeight(), 0, 0, mpBarLen, mp.getHeight(), null);
        g.setFont(dialogFont);
        g.setColor(Color.green);
        String mpstr = this.pc.mp + "/" + this.pc.mpMax;
        int mpstrlen = g.getFontMetrics().stringWidth(mpstr);
        g.drawString(mpstr, this.x + 208 + mpBarLen / 2 - mpstrlen / 2, this.y + 25);
        g.setColor(Color.decode("0x42A5C6"));
        for (int i = 0; i < 4; ++i) {
            int textH = g.getFontMetrics(dialogFont).getHeight();
            try {
                String txt = ((MenuItem)this.options.get((int)(i + this.cursOffset))).text;
                if (this.selection == i + this.cursOffset && this.active) {
                    txt = this.disabledIDs.contains(this.selection) ? "X " + txt : "\u25b6 " + txt;
                }
                g.drawString(txt, this.x + 25, this.y + 44 + (i + 1) * textH - this.textoffset);
                continue;
            }
            catch (IndexOutOfBoundsException ignored) {
                // empty catch block
            }
        }
        this.active = false;
        this.drewn = true;
    }
}

