/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2;

import ca.noxid.peng2.KeyMapping;
import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.SoundPlayer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;

public class DialogBox {
    int x;
    int y;
    int w;
    int h;
    int textoffset = 0;
    int currentLine;
    int currentChar;
    boolean paused = false;
    boolean triggered = false;
    int txtDelay;
    TEXT_ALIGN align = TEXT_ALIGN.LEFT;
    Runnable trigger;
    String[] text = new String[0];
    String[] lines = new String[0];
    int textH = 20;
    public static Rectangle defaultDagSize = new Rectangle(20, 240, 600, 100);
    static Font dialogFont = new Font("SansSerif", 0, 18);

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    DialogBox(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    DialogBox(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.w = r.width;
        this.h = r.height;
    }

    public void setTrigger(Runnable r) {
        this.trigger = r;
        this.triggered = false;
    }

    public void setText(String t, boolean immediate) {
        this.text = t.split("\n");
        this.lines = new String[this.text.length];
        Arrays.fill(this.lines, "");
        this.currentLine = 0;
        this.textoffset = 0;
        this.currentChar = 0;
        this.paused = false;
        if (immediate) {
            this.lines = this.text;
            this.currentLine = this.lines.length;
        }
    }

    public void draw(Graphics g) {
        g.setColor(new Color(0, 0, 0, 128));
        g.fillRect(this.x, this.y, this.w, this.h);
        this.textH = g.getFontMetrics(dialogFont).getHeight();
        g.setClip(this.x + 8, this.y + 8, this.w - 16, this.h - 16);
        g.setFont(dialogFont);
        g.setColor(Color.white);
        block4: for (int i = 0; i < this.lines.length; ++i) {
            switch (this.align) {
                case LEFT: {
                    g.drawString(this.lines[i], this.x + 8, this.y + 8 + (i + 1) * this.textH - this.textoffset);
                    continue block4;
                }
                case CENTER: {
                    int stringw = g.getFontMetrics().stringWidth(this.lines[i]);
                    int myw = g.getClipBounds().width - 16;
                    g.drawString(this.lines[i], this.x + 8 + (myw - stringw) / 2, this.y + 8 + (i + 1) * this.textH - this.textoffset);
                    continue block4;
                }
            }
        }
    }

    public void update(KeyUpdate update) {
        int targety;
        if (update.pressed(KeyMapping.GAMEKEYS.KEY_JUMP)) {
            this.paused = false;
            if (this.trigger != null && this.currentLine == this.text.length && !this.triggered) {
                this.triggered = true;
                this.trigger.run();
            }
        }
        if (this.currentLine < this.text.length && !this.paused) {
            this.txtDelay -= update.held(KeyMapping.GAMEKEYS.KEY_JUMP) ? 4 : 1;
            if (this.txtDelay <= 0) {
                this.txtDelay = 4;
                try {
                    int n = this.currentLine;
                    this.lines[n] = this.lines[n] + this.text[this.currentLine].charAt(this.currentChar);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                ++this.currentChar;
                SoundPlayer.player.playSound(3, 2);
                if (this.currentChar >= this.text[this.currentLine].length()) {
                    this.currentChar = 0;
                    ++this.currentLine;
                }
            }
        }
        int n = targety = this.currentLine == this.lines.length ? (this.currentLine + 1) * this.textH : (this.currentLine + 2) * this.textH;
        if (targety > this.textoffset + this.h) {
            this.textoffset += 4;
        }
    }

    public void appendText(String s, boolean b) {
        String[] split = s.split("\n");
        int oldLen = this.text.length;
        int newLen = this.text.length + split.length;
        this.text = Arrays.copyOfRange(this.text, 0, newLen);
        this.lines = Arrays.copyOfRange(this.lines, 0, newLen);
        for (int i = 0; i < newLen - oldLen; ++i) {
            this.text[i + oldLen] = split[i];
            this.lines[i + oldLen] = "";
        }
    }

    static enum TEXT_ALIGN {
        LEFT,
        CENTER,
        RIGHT;

    }
}

