/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2;

import ca.noxid.peng2.DialogBox;
import ca.noxid.peng2.KeyMapping;
import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.MenuItem;
import ca.noxid.peng2.SoundPlayer;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Menu
extends DialogBox {
    String title;
    List<MenuItem> options = new ArrayList<MenuItem>();
    int selection;
    boolean drewn = false;
    boolean active = false;
    Set<Integer> disabledIDs = new HashSet<Integer>();

    Menu(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    Menu(int x, int y, int w, int h, List<MenuItem> options) {
        super(x, y, w, h);
        this.options = options;
    }

    public void setOptions(List<MenuItem> opt) {
        this.options = opt;
    }

    @Override
    public void update(KeyUpdate update) {
        this.active = true;
        if (update.pressed(KeyMapping.GAMEKEYS.KEY_UP)) {
            --this.selection;
            if (this.selection < 0) {
                this.selection = this.options.size() - 1;
            }
            SoundPlayer.player.playSound(2);
            if (this.options.get((int)this.selection).onSwitch != null) {
                this.options.get((int)this.selection).onSwitch.run();
            }
        }
        if (update.pressed(KeyMapping.GAMEKEYS.KEY_DOWN)) {
            ++this.selection;
            if (this.selection > this.options.size() - 1) {
                this.selection = 0;
            }
            SoundPlayer.player.playSound(2);
            if (this.options.get((int)this.selection).onSwitch != null) {
                this.options.get((int)this.selection).onSwitch.run();
            }
        }
        if (update.pressed(KeyMapping.GAMEKEYS.KEY_JUMP) && this.drewn) {
            if (!this.disabledIDs.contains(this.selection)) {
                this.options.get((int)this.selection).action.run();
                SoundPlayer.player.playSound(4);
            } else {
                SoundPlayer.player.playSound(5);
            }
        }
    }

    @Override
    public void draw(Graphics g) {
        if (!this.active) {
            g.setColor(new Color(0, 0, 0, 128));
        } else {
            g.setColor(new Color(26, 55, 97, 228));
        }
        g.fillRect(this.x, this.y, this.w, this.h);
        g.setFont(dialogFont);
        g.setColor(Color.white);
        g.setClip(this.x + 8, this.y + 8, this.w - 16, this.h - 16);
        int textH = g.getFontMetrics(dialogFont).getHeight();
        int maxH = (this.h - 16 + this.textoffset) / textH;
        int minH = this.textoffset / textH;
        if (this.selection < minH) {
            this.textoffset -= textH;
        } else if (this.selection >= maxH) {
            this.textoffset += textH;
        }
        for (int i = 0; i < this.options.size() && i < maxH; ++i) {
            String txt = this.options.get((int)i).text;
            if (this.selection == i && this.active) {
                txt = this.disabledIDs.contains(this.selection) ? "X " + txt : "\u25b6 " + txt;
            }
            if (i < minH) continue;
            g.drawString(txt, this.x + 8, this.y + 8 + (i + 1) * textH - this.textoffset);
        }
        this.drewn = true;
        this.active = false;
    }

    public void disable(int[] ids) {
        for (int i : ids) {
            this.disabledIDs.add(i);
        }
    }

    public void clearDisabledOptions() {
        this.disabledIDs.clear();
    }
}

