/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Set;
import javax.imageio.ImageIO;

public class ResourceManager {
    private static final String[] jarImgs = new String[]{"_hp2title.png", "_pengzone.peng", "_clark1.png", "_clark2.png", "_clarkstand.png", "_hp2title.png", "_mocksave.png", "_save.png", "prf1.png", "prf2.png", "prf3.png"};
    public static File peng3 = new File("file/Abigale.peng");
    public static File battlemenu = new File("file/select.png");
    public static File mpbar = new File("file/mpBar.png");
    public static File selector = new File("file/selector.png");
    public static File ded = new File("file/ded.png");
    private HashMap<File, BufferedImage> imgMap = new HashMap();
    private HashMap<File, byte[]> pxaMap = new HashMap();
    public static File bg1 = new File("file/sunzy.png");
    public static File bg2 = new File("file/spiss.png");
    public static File pumpk = new File("file/pumpknight.png");
    public static File clark = new File("file/clark.png");
    public static File future = new File("file/future.png");
    public static File cage = new File("file/fagecuck.png");
    public static File peng1 = new File("file/Fallen angel Peng.peng");
    public static File peng2 = new File("file/Galaxy Peng.peng");
    public static File hp1 = new File("file/hpBase.png");
    public static File hp2 = new File("file/hpGreen.png");
    public static File finalhp = new File("file/superhp.png");
    public static File over = new File("file/Game over.png");
    public static File sun = new File("file/sin.png");
    public static File darkPeng = new File("file/DarknessComes.peng");
    public static ResourceManager rm = new ResourceManager();

    public ResourceManager() {
        this.loadFiles();
    }

    private void loadFiles() {
        ResourceManager rm = this;
        rm.addImage(bg1, 0);
        rm.addImage(peng1, 0);
        rm.addImage(bg2, 0);
        rm.addImage(pumpk, 0);
        rm.addImage(clark, 0);
        rm.addImage(future, 0);
        rm.addImage(cage, 0);
        rm.addImage(peng2, 0);
        rm.addImage(peng3, 0);
        rm.addImage(hp1, 0);
        rm.addImage(hp2, 0);
        rm.addImage(battlemenu, 0);
        rm.addImage(mpbar, 0);
        rm.addImage(selector, 0);
        rm.addImage("file/stat1.peng", 0);
        rm.addImage("file/stat2.peng", 0);
        rm.addImage("file/stat3.peng", 0);
        rm.addImage(finalhp, 0);
        rm.addImage(ded, 0);
        rm.addImage(over, 0);
        rm.addImage(sun, 0);
        rm.addImage(darkPeng, 0);
        File fxBase = new File("file/eFFECTS");
        File[] fex = fxBase.listFiles();
        if (fex != null) {
            for (File f : fex) {
                rm.addImage(f, 0);
            }
        }
        for (int i = 1; i < 13; ++i) {
            rm.addImage(new File("file/superhpfill" + i + ".png"), 0);
        }
        try {
            for (String s : jarImgs) {
                InputStream is = ResourceManager.class.getResourceAsStream(s);
                this.imgMap.put(new File(s), ImageIO.read(is));
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void listall() {
        Set<File> ks = this.imgMap.keySet();
        for (File f : ks) {
            System.out.println(f);
        }
    }

    public void addImage(String srcFile, int filterType) {
        this.addImage(new File(srcFile), filterType);
    }

    public boolean addImage(File srcFile, int filterType) {
        if (!(srcFile = ResourceManager.checkBase(srcFile)).exists()) {
            System.out.println("Can't load " + srcFile);
            return false;
        }
        try {
            File imgFile = srcFile;
            if (this.imgMap.containsKey(imgFile)) {
                return true;
            }
            FileInputStream is = new FileInputStream(srcFile);
            switch (filterType) {
                case 0: {
                    this.imgMap.put(srcFile, ImageIO.read(is));
                    break;
                }
                case 1: {
                    BufferedImage img = ImageIO.read(is);
                    if (srcFile.getName().endsWith(".png")) {
                        this.imgMap.put(srcFile, this.magenta2Trans(img));
                        break;
                    }
                    this.imgMap.put(srcFile, this.black2Trans(img));
                }
            }
            is.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void reloadImage(String src, int filterType) {
        this.reloadImage(new File(src), filterType);
    }

    public void reloadImage(File srcFile, int filterType) {
        if (this.imgMap.containsKey(srcFile = ResourceManager.checkBase(srcFile))) {
            this.imgMap.get(srcFile).flush();
            this.imgMap.remove(srcFile);
        }
        this.addImage(srcFile, filterType);
    }

    public Graphics getImgGraphics(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key).getGraphics();
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return null;
    }

    public BufferedImage getImg(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key);
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return null;
    }

    public BufferedImage getImg(String key) {
        return this.getImg(new File(key));
    }

    public int getImgH(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key).getHeight();
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return -1;
    }

    public int getImgW(File key) {
        if (this.imgMap.containsKey(key = ResourceManager.checkBase(key))) {
            return this.imgMap.get(key).getWidth();
        }
        System.err.println("Key not found for getImgGraphics");
        System.err.println(key);
        return -1;
    }

    private BufferedImage black2Trans(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 3);
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int px = src.getRGB(x, y);
                if (px == -16777216) {
                    dest.setRGB(x, y, 0);
                    continue;
                }
                dest.setRGB(x, y, px);
            }
        }
        return dest;
    }

    private BufferedImage magenta2Trans(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 3);
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int px = src.getRGB(x, y);
                if (px == -65281) {
                    dest.setRGB(x, y, 0);
                    continue;
                }
                dest.setRGB(x, y, px);
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] addPxa(File srcFile, int size) {
        srcFile = ResourceManager.checkBase(srcFile);
        AbstractInterruptibleChannel inChan = null;
        if (this.pxaMap.containsKey(srcFile)) {
            return this.pxaMap.get(srcFile);
        }
        byte[] pxaArray = null;
        boolean succ = false;
        try {
            FileInputStream inStream = new FileInputStream(srcFile);
            inChan = inStream.getChannel();
            ByteBuffer pxaBuf = ByteBuffer.allocate(size);
            ((FileChannel)inChan).read(pxaBuf);
            inChan.close();
            inStream.close();
            pxaBuf.flip();
            pxaArray = pxaBuf.array();
            this.pxaMap.put(srcFile, pxaArray);
            succ = true;
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inChan != null) {
                try {
                    inChan.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!succ && srcFile != null) {
                byte[] dummyArray = new byte[size];
                this.pxaMap.put(srcFile, dummyArray);
            }
        }
        return pxaArray;
    }

    public byte[] addPxa(String src, int size) {
        return this.addPxa(new File(src), size);
    }

    public byte[] getPxa(File srcFile) {
        srcFile = ResourceManager.checkBase(srcFile);
        return this.pxaMap.get(srcFile);
    }

    public byte[] getPxa(String src) {
        return this.getPxa(new File(src));
    }

    public void savePxa(File srcFile) {
        try {
            FileOutputStream out = new FileOutputStream(srcFile);
            FileChannel outChan = out.getChannel();
            ByteBuffer pxaBuf = ByteBuffer.wrap(this.getPxa(srcFile));
            outChan.write(pxaBuf);
            outChan.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void purge() {
        for (BufferedImage b : this.imgMap.values()) {
            b.flush();
        }
        this.imgMap.clear();
        this.pxaMap.clear();
    }

    public static File getBaseFolder(File currentLoc) {
        String place = "/";
        if (currentLoc == null) {
            return null;
        }
        while (!currentLoc.getName().equals("mod")) {
            place = "/" + currentLoc.getName() + place;
            if (currentLoc.getParentFile() == null) {
                return null;
            }
            currentLoc = currentLoc.getParentFile();
        }
        currentLoc = currentLoc.getParentFile();
        currentLoc = currentLoc.getParentFile();
        currentLoc = new File(currentLoc + "/base");
        return currentLoc;
    }

    public static File checkBase(File res) {
        if (res.exists()) {
            return res;
        }
        File currentLoc = res.getParentFile();
        String place = "/";
        if (currentLoc == null) {
            return res;
        }
        while (!currentLoc.getName().equals("mod")) {
            place = "/" + currentLoc.getName() + place;
            if (currentLoc.getParentFile() == null) {
                return res;
            }
            currentLoc = currentLoc.getParentFile();
        }
        currentLoc = currentLoc.getParentFile();
        currentLoc = currentLoc.getParentFile();
        File target = new File((currentLoc = new File(currentLoc + "/base")) + place + res.getName());
        if (target.exists()) {
            return target;
        }
        return res;
    }
}

