/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2;

import ca.noxid.peng2.Peng2Ap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SoundPlayer {
    static final int SOUNDCHANNELS = 16;
    public boolean corrupt = false;
    static float volume = 100.0f;
    String directory = "file/";
    private final String[] soundArray = this.getSounds();
    private boolean[] soundChannels = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private ArrayList<byte[]> sfxArray;
    private SoundThread soundThread;
    private ArrayList<PlaySound> soundThreads;
    private ArrayList<Vector2> playedThisFrame = new ArrayList();
    SourceDataLine[] lines;
    public static final SoundPlayer player = new SoundPlayer();

    private String[] getSounds() {
        return new String[]{"err.wav", "pengsecret2.wav", "blip.wav", "blip_q.wav", "pengchoice.wav", "no.wav", "pengsave.wav", "HELLO2.wav", "pengbump.wav", "PengRoar.wav", "PengRoar2.wav", "Physical.wav", "penglaugh.wav", "goodby.wav", "posi.wav", "neg.wav", "something.wav", "release.wav", "pech.wav", "enflame.wav", "defender.wav", "appearance2.wav", "build2.wav", "groupheal.wav", "spadoo.wav", "lilburn.wav", "chilly.wav", "bigzap.wav", "chiller.wav", "bigflame.wav", "sad.wav", "aaAAaaa.wav", "steely.wav", "dangerous.wav", "unreality.wav", "crash.wav", "over.wav", "Meow1.wav", "static.wav", "explody.wav", "esaeler.wav", "doomnote.wav"};
    }

    public SoundPlayer() {
        this.resetAllChannels();
        this.soundThreads = new ArrayList();
        this.soundThread = new SoundThread();
        this.soundThread.initSounds();
        this.loadAllSounds();
        this.soundThread.start();
        ByteArrayInputStream is = new ByteArrayInputStream(this.sfxArray.get(0));
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(is);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, stream.getFormat(), (int)(stream.getFrameLength() * (long)format.getFrameSize()));
            this.lines = new SourceDataLine[16];
            for (int i = 0; i < 16; ++i) {
                this.lines[i] = (SourceDataLine)AudioSystem.getLine(info);
                this.lines[i].open(stream.getFormat());
                this.lines[i].start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Timer timer = new Timer();
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                SoundPlayer.this.soundAI();
            }
        };
        timer.scheduleAtFixedRate(tt, 0L, 33L);
    }

    private void loadAllSounds() {
        this.sfxArray = new ArrayList();
        for (String aSoundArray : this.soundArray) {
            try {
                this.sfxArray.add(SoundPlayer.getBytesFromFile(new File(this.directory + aSoundArray)));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void resetAllChannels() {
        for (int i = 0; i < 16; ++i) {
            this.soundChannels[i] = false;
        }
    }

    public void playSound(int soundNumb) {
        this.playSound(soundNumb, 0);
    }

    public void soundAI() {
        if (this.soundThread.isPlaying()) {
            return;
        }
        ArrayList<Vector2> S = new ArrayList<Vector2>(this.playedThisFrame);
        this.soundThread.playSounds(S);
        this.playedThisFrame = new ArrayList();
    }

    public void playSound(int soundNumb, int soundChannel) {
        if (Peng2Ap.cheatcode("hello kitty")) {
            soundNumb = 37;
        }
        for (Vector2 V : this.playedThisFrame) {
            if (V.x != soundNumb) continue;
            return;
        }
        while (soundChannel < 16) {
            if (!this.soundChannels[soundChannel]) {
                this.playedThisFrame.add(new Vector2(soundNumb, soundChannel));
                this.soundChannels[soundChannel] = true;
                return;
            }
            ++soundChannel;
        }
    }

    public void freeChannel(int soundChannel) {
        this.soundChannels[soundChannel] = false;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        InputStream is;
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        if (file.exists()) {
            is = new FileInputStream(file);
        } else {
            String a = file.getName().equals("aaAAaaa.wav") ? "aaAAaaa.wav" : "err.wav";
            is = SoundPlayer.class.getResourceAsStream(a);
        }
        int numRead = 0;
        if (bytes.length > 0) {
            for (int offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        } else {
            ArrayList<byte[]> barrys = new ArrayList<byte[]>();
            while (is.available() > 0) {
                byte[] chunk = new byte[is.available()];
                int atmread = is.read(chunk);
                chunk = Arrays.copyOf(chunk, atmread);
                barrys.add(chunk);
            }
            int totlen = 0;
            for (byte[] b : barrys) {
                totlen += b.length;
            }
            ByteBuffer bb = ByteBuffer.allocate(totlen);
            for (byte[] b : barrys) {
                bb.put(b, 0, b.length);
                System.out.println("bb at " + bb.position());
            }
            bytes = bb.array();
            System.out.println(bytes.length);
        }
        is.close();
        return bytes;
    }

    class Vector2 {
        int x;
        int y;

        public Vector2(int x1, int y1) {
            this.x = x1;
            this.y = y1;
        }
    }

    public class PlaySound
    extends Thread {
        byte[] sound;
        boolean muted = false;
        float pan = 0.0f;
        private int soundNumb;
        private int channel;
        double seconds = 0.0;
        SourceDataLine line;
        boolean looped_forever = false;
        boolean playing = true;
        boolean started = false;
        int loop_times = 0;
        int loops_done = 0;

        public void setNumb(Vector2 s) {
            this.soundNumb = s.x;
            this.channel = s.y;
        }

        public void stopSound() {
            this.playing = false;
        }

        @Override
        public void run() {
            try {
                this.line = SoundPlayer.this.lines[this.channel];
                this.line.start();
                this.sound = (byte[])SoundPlayer.this.sfxArray.get(this.soundNumb);
                ByteArrayInputStream i = new ByteArrayInputStream(this.sound);
                AudioInputStream stream = AudioSystem.getAudioInputStream(i);
                AudioFormat format = stream.getFormat();
                try {
                    FloatControl volume_control = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                    volume_control.setValue((float)(Math.log(volume / 100.0f) / Math.log(10.0) * 20.0));
                }
                catch (IllegalArgumentException err) {
                    System.err.println("NO GAIN CONTROL");
                }
                try {
                    BooleanControl mute_control = (BooleanControl)this.line.getControl(BooleanControl.Type.MUTE);
                    mute_control.setValue(this.muted);
                }
                catch (IllegalArgumentException err) {
                    System.err.println("NO MUTE CONTROL");
                }
                int num_read = 0;
                byte[] buf = new byte[1000];
                while ((num_read = stream.read(buf, 0, buf.length)) >= 0 && this.playing) {
                    for (int offset = 0; offset < num_read && this.playing; offset += this.line.write(buf, offset, num_read - offset)) {
                    }
                    this.started = true;
                }
                for (int k = 0; k < 50 && this.playing; ++k) {
                    Thread.sleep(50L);
                }
                this.line.flush();
                this.line.stop();
                i.close();
                stream.close();
                ((SoundPlayer)SoundPlayer.this).soundChannels[this.channel] = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class SoundThread
    extends Thread {
        private boolean play = false;
        private ArrayList<Vector2> sounds;
        private ArrayList<PlaySound> removeSounds;

        SoundThread() {
        }

        public void initSounds() {
            this.sounds = new ArrayList();
            this.removeSounds = new ArrayList();
        }

        public void playSounds(ArrayList<Vector2> soundlist) {
            if (soundlist.size() == 0) {
                return;
            }
            this.sounds = soundlist;
            this.play = true;
        }

        public boolean isPlaying() {
            return this.play;
        }

        @Override
        public void run() {
            while (true) {
                long timeTaken;
                long beginTime = System.nanoTime();
                while (this.play) {
                    for (Vector2 I : this.sounds) {
                        boolean playSound = true;
                        for (PlaySound P : SoundPlayer.this.soundThreads) {
                            if (P.soundNumb != I.x) continue;
                            if (P.started) {
                                P.stopSound();
                                this.removeSounds.add(P);
                                continue;
                            }
                            playSound = false;
                        }
                        for (PlaySound P : this.removeSounds) {
                            SoundPlayer.this.soundThreads.remove(P);
                        }
                        if (!playSound) continue;
                        PlaySound Player = new PlaySound();
                        Player.setNumb(I);
                        Player.start();
                        SoundPlayer.this.soundThreads.add(Player);
                    }
                    this.sounds.clear();
                    this.play = false;
                    timeTaken = System.nanoTime() - beginTime;
                }
                timeTaken = System.nanoTime() - beginTime;
                long timeLeft = (Peng2Ap.UPDATE_PERIOD - timeTaken) / 1000000L;
                if (timeLeft < 10L) {
                    timeLeft = 10L;
                }
                try {
                    Thread.sleep(timeLeft);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }
}

