/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2.battlers;

import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.Peng2Ap;
import ca.noxid.peng2.attack.pengs.Confuzzle;
import ca.noxid.peng2.attack.pengs.Introspection;
import ca.noxid.peng2.attack.pengs.Soar;
import ca.noxid.peng2.attack.pengs.SpreadDisease;
import ca.noxid.peng2.attack.pengs.TenKayPecs;
import ca.noxid.peng2.attack.pengs.WingSwipe;
import ca.noxid.peng2.battlers.Fightant;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;

public class AngelPeng
extends Fightant {
    boolean inSky = false;

    public AngelPeng(int h, int m, int a, int d, BufferedImage s) {
        super(h, m, a, d, s);
        this.name = "Fallen Angel Peng";
        this.baseDodge = 0.049f;
        this.baseDefens = 0.05f;
    }

    @Override
    public void updateState() {
        switch (this.scriptstate) {
            case 0: {
                if (this.y > 0) {
                    --this.y;
                    this.x = Peng2Ap.appRand.nextInt(6) - 3;
                    break;
                }
                this.x = 0;
                this.scriptstate = 1;
                break;
            }
            case 1: {
                break;
            }
            case 10: {
                ++this.y;
                this.x = Peng2Ap.appRand.nextInt(8) - 4;
                break;
            }
            case 20: {
                if (this.y <= -1000) break;
                this.y -= 3;
                break;
            }
            case 21: {
                this.x = 0;
                this.y = 0;
                this.scriptstate = 1;
                break;
            }
            case 22: {
                this.x = -600;
                this.y = 100;
                ++this.scriptstate;
            }
            case 23: {
                this.x += 18;
                if (this.x <= 600) break;
                this.scriptstate = 30;
                break;
            }
            case 30: {
                this.x /= 2;
                this.y /= 2;
                if (Math.abs(this.x) + Math.abs(this.y) >= 6) break;
                this.scriptstate = 21;
                this.inSky = false;
                this.dodge = this.baseDodge;
            }
        }
    }

    @Override
    public int chooseAttack(List<Fightant> targets, KeyUpdate update) {
        double attack = Peng2Ap.appRand.nextDouble();
        if (this.inSky) {
            this.nextAction = new Soar("Penguin swoops!", (Fightant)this, false);
            this.nextAction.setTarget(targets);
            return 1;
        }
        if (attack < 0.3) {
            this.nextAction = new WingSwipe(this);
        } else if (attack < 0.4) {
            this.nextAction = new TenKayPecs(this);
        } else if (attack < 0.6) {
            this.nextAction = new SpreadDisease(this);
            this.speed = -100;
        } else if (attack < 0.8) {
            this.nextAction = new Soar("Penguin soars up high!", (Fightant)this, true);
            this.inSky = true;
        } else {
            this.nextAction = attack < 0.9 ? new Introspection(this) : new Confuzzle(this);
        }
        this.nextAction.setTarget(targets);
        return 1;
    }

    @Override
    public void drawSelf(Graphics g) {
        g.drawImage(this.sprite, this.x, this.y, null);
    }

    @Override
    public void drawHealth(Graphics g) {
        if (this.scriptstate == 1) {
            super.drawHealth(g);
        }
    }

    @Override
    public void rebase() {
        super.rebase();
        if (this.inSky) {
            this.dodge = 1.0f;
        }
    }

    @Override
    public Point getCenter() {
        return new Point(323, 185);
    }
}

