/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2.battlers;

import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.Numbers;
import ca.noxid.peng2.Peng2Ap;
import ca.noxid.peng2.ResourceManager;
import ca.noxid.peng2.attack.BattleAction;
import ca.noxid.peng2.attack.DAMAGE_TYPE;
import ca.noxid.peng2.status.Status;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Fightant
implements Comparable {
    public int hp;
    public int hpMax;
    public int mp;
    public int mpMax;
    public int attack;
    public int baseAttack;
    public float defens;
    public float baseDefens;
    public float dodge;
    public float baseDodge;
    public BufferedImage sprite;
    public float damagemod = 1.0f;
    public int x;
    public int y;
    public int initiative;
    public int speed;
    int owTimer;
    public boolean exist = true;
    public BattleAction nextAction;
    Map<DAMAGE_TYPE, Float> resistances;
    public String name;
    List<Numbers> nubs = new ArrayList<Numbers>();
    private List<Status> statuses = new ArrayList<Status>();
    public int scriptstate;
    public boolean introspected = false;

    public Fightant(int h, int m, int a, int d, BufferedImage s) {
        this.hp = this.hpMax = h;
        this.mpMax = m;
        this.mp = m;
        this.baseAttack = a;
        this.attack = a;
        this.defens = this.baseDefens = (float)d / 100.0f;
        this.sprite = s;
        this.resistances = new HashMap<DAMAGE_TYPE, Float>();
        this.resistances.put(DAMAGE_TYPE.ELEC, Float.valueOf(1.0f));
        this.resistances.put(DAMAGE_TYPE.FIRE, Float.valueOf(1.0f));
        this.resistances.put(DAMAGE_TYPE.ICE, Float.valueOf(1.0f));
        this.resistances.put(DAMAGE_TYPE.PHYS, Float.valueOf(1.0f));
        this.resistances.put(DAMAGE_TYPE.PURE, Float.valueOf(1.0f));
    }

    public void draw(Graphics g) {
        if (this.exist) {
            g = g.create();
            for (Status s : this.getStatuses()) {
                s.preDraw(g);
            }
            this.drawSelf(g);
            for (Status s : this.getStatuses()) {
                s.postDraw(g);
            }
        }
    }

    public void drawSelf(Graphics g) {
        int yoff = 0;
        if (this.owTimer > 0) {
            --this.owTimer;
            yoff = Peng2Ap.appRand.nextInt(16) - 8;
        }
        BufferedImage tome = ResourceManager.rm.getImg(ResourceManager.ded);
        if (this.hp > 0) {
            g.drawImage(this.sprite, this.x, this.y + yoff, null);
        } else {
            g.drawImage(tome, this.x, this.y + yoff, null);
        }
    }

    public void update() {
        this.updateState();
        this.updateStatuses();
        this.updateNums();
    }

    protected void updateStatuses() {
        for (Status s : this.getStatuses()) {
            s.update();
        }
    }

    public void addStatus(Status sin, boolean onlyOne) {
        if (this.exists() && this.dodge < 1.0f) {
            sin.setAffected(this);
            if (onlyOne) {
                for (Status s : this.getStatuses()) {
                    if (s.getClass() != sin.getClass()) continue;
                    this.statuses.remove(s);
                    break;
                }
            }
            this.getStatuses().add(sin);
        }
    }

    public abstract void updateState();

    public void rollForInitiative() {
        this.initiative = Peng2Ap.appRand.nextInt(100) + this.speed;
    }

    public abstract int chooseAttack(List<Fightant> var1, KeyUpdate var2);

    public BattleAction performAction() {
        return this.nextAction;
    }

    public void applyDamage(int power, DAMAGE_TYPE type) {
        double hitAmt = power;
        if (type != DAMAGE_TYPE.PURE) {
            hitAmt = (double)power * (1.0 - (double)this.defens);
            double randomness = Peng2Ap.appRand.nextDouble() / 10.0 - 0.05;
            hitAmt += (double)power * randomness;
        }
        hitAmt *= (double)this.resistances.get((Object)type).floatValue();
        if (type == DAMAGE_TYPE.PURE || Peng2Ap.appRand.nextDouble() > (double)this.dodge) {
            if (hitAmt > (double)this.hp) {
                hitAmt = this.hp;
            }
            this.nubs.add(new Numbers((int)(-hitAmt)));
            this.hp = (int)((double)this.hp - hitAmt);
            this.owTimer = 15;
        } else {
            this.nubs.add(new Numbers("Miss!"));
        }
        if (this.hp <= 0) {
            this.statuses.clear();
        }
    }

    public void applyHeal(int amt, boolean canRevive) {
        if (this.hp + amt > this.hpMax) {
            amt = this.hpMax - this.hp;
        }
        if (this.hp <= 0 && canRevive) {
            this.hp += amt;
            this.nubs.add(new Numbers(amt));
        } else if (this.hp > 0 && !canRevive) {
            this.hp += amt;
            this.nubs.add(new Numbers(amt));
        }
    }

    public void updateNums() {
        ArrayList<Numbers> remove = new ArrayList<Numbers>();
        for (Numbers n : this.nubs) {
            if (!n.update()) continue;
            remove.add(n);
        }
        this.nubs.removeAll(remove);
    }

    public abstract Point getCenter();

    public void drawHealth(Graphics g) {
        Point me = this.getCenter();
        BufferedImage hpBase = ResourceManager.rm.getImg(ResourceManager.hp1);
        BufferedImage hpBar = ResourceManager.rm.getImg(ResourceManager.hp2);
        int baseW = hpBase.getWidth();
        int bx = me.x - baseW / 2;
        int by = me.y - 73;
        int wide = (int)((float)this.hp / (float)this.hpMax * (float)baseW);
        g.drawImage(hpBase, bx, by, null);
        g.drawImage(hpBar, bx, by, bx + wide, by + hpBar.getHeight(), 0, 0, wide, hpBar.getHeight(), null);
    }

    public void drawHitNumbers(Graphics g) {
        Point me = this.getCenter();
        for (Numbers n : this.nubs) {
            n.draw(g, me);
        }
    }

    public int compareTo(Object other) {
        if (other instanceof Fightant) {
            return Integer.compare(this.initiative, ((Fightant)other).initiative);
        }
        return 0;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public void rebase() {
        this.attack = this.baseAttack;
        this.defens = this.baseDefens;
        this.speed = 0;
        this.dodge = this.baseDodge;
        this.damagemod = 1.0f;
        this.exist = true;
    }

    public void restoreMagic(int mag) {
        this.mp += mag;
        if (this.mp > this.mpMax) {
            this.mp = this.mpMax;
        }
        this.nubs.add(new Numbers(mag, Color.magenta));
    }

    public void disableMenu(int ... vals) {
    }

    public boolean exists() {
        return this.exist;
    }
}

