/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2.battlers;

import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.Peng2Ap;
import ca.noxid.peng2.ResourceManager;
import ca.noxid.peng2.SoundPlayer;
import ca.noxid.peng2.attack.BattleAction;
import ca.noxid.peng2.attack.DAMAGE_TYPE;
import ca.noxid.peng2.attack.pengs.BasicPengAttack;
import ca.noxid.peng2.attack.pengs.DubAttack;
import ca.noxid.peng2.attack.pengs.Goodbye;
import ca.noxid.peng2.attack.pengs.HairFlip;
import ca.noxid.peng2.attack.pengs.PengCry;
import ca.noxid.peng2.attack.pengs.PengPity;
import ca.noxid.peng2.attack.pengs.PengSun;
import ca.noxid.peng2.attack.pengs.Release;
import ca.noxid.peng2.attack.pengs.SilentLaugh;
import ca.noxid.peng2.attack.pengs.TheOver;
import ca.noxid.peng2.attack.pengs.Unreality;
import ca.noxid.peng2.attack.players.MagicSpell;
import ca.noxid.peng2.battlers.Fightant;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FinalPeng
extends Fightant {
    int scripttimer;
    int dy = 0;
    int yOff = -200;
    boolean goodbye = false;
    boolean doubleact = false;
    int hpframe;
    ArrayList<Circ> circs = new ArrayList();
    ArrayList<PengDust> dusts = new ArrayList();
    private static final Color[] circColors = new Color[]{Color.magenta, Color.green, Color.yellow, Color.white};

    public FinalPeng(int h, int m, int a, int d, BufferedImage s) {
        super(h, m, a, d, s);
        this.name = "Arisen Penguin";
    }

    @Override
    public void updateState() {
        if (this.scriptstate > 1 && this.scriptstate <= 99) {
            ++this.scripttimer;
            if (this.scripttimer > 5) {
                this.scripttimer = 0;
                --this.scriptstate;
            }
        }
        ArrayList<Circ> deadCircs = new ArrayList<Circ>();
        for (Circ c : this.circs) {
            c.update();
            if (c.timer <= 120) continue;
            deadCircs.add(c);
        }
        this.circs.removeAll(deadCircs);
        ArrayList<PengDust> ddust = new ArrayList<PengDust>();
        for (PengDust c : this.dusts) {
            if (!c.update()) continue;
            ddust.add(c);
        }
        this.dusts.removeAll(ddust);
        switch (this.scriptstate) {
            case 0: {
                this.dy += this.yOff >= 0 ? -2 : 2;
                this.yOff += this.dy;
                break;
            }
            case 100: {
                this.scriptstate = 0;
                for (int i = 0; i < 300; ++i) {
                    this.circs.add(new Circ(this.x + this.sprite.getWidth() / 2, this.y + this.sprite.getHeight() / 2));
                }
            }
            case 101: {
                if (this.yOff > 0) {
                    this.yOff -= 100;
                }
                if (this.yOff < 0) {
                    this.yOff += 100;
                }
                if (Math.abs(this.yOff) >= 100) break;
                ++this.scriptstate;
                SoundPlayer.player.playSound(10);
                this.yOff = 0;
                this.dy = 0;
                this.scripttimer = 0;
                break;
            }
            case 102: {
                ++this.scripttimer;
                if (this.scripttimer <= 150) break;
                ++this.scriptstate;
                break;
            }
            case 103: {
                int dustY;
                ++this.scripttimer;
                if (this.scripttimer % 20 == 0 && this.scripttimer < 480) {
                    SoundPlayer.player.playSound(38);
                }
                Point pc = this.getCenter();
                int n = dustY = 250 < 530 - this.scripttimer ? 250 : 530 - this.scripttimer;
                if (dustY > 50) {
                    for (int i = 0; i < 5; ++i) {
                        this.dusts.add(new PengDust(pc.x - 10, dustY));
                    }
                }
                if (dustY > 0) break;
                ++this.scriptstate;
                break;
            }
        }
        if (++this.hpframe >= 36) {
            this.hpframe = 0;
        }
    }

    @Override
    public int chooseAttack(List<Fightant> targets, KeyUpdate update) {
        double attack = Peng2Ap.appRand.nextDouble();
        if (this.goodbye) {
            this.goodbye = false;
            this.nextAction = new Goodbye(this);
            this.nextAction.setTarget(targets);
            return 1;
        }
        if (this.doubleact) {
            this.doubleact = false;
            this.nextAction = new DubAttack(this, this.dubAttack(targets), this.dubAttack(targets));
            return 1;
        }
        if (attack < 0.15) {
            this.nextAction = new BasicPengAttack("Flex", this, 4000, new File("file/eFFECTS/HeavyStrike.png"), DAMAGE_TYPE.PHYS);
        } else if (attack < 0.33) {
            this.nextAction = new HairFlip(this);
        } else if (attack < 0.38) {
            this.nextAction = new SilentLaugh(this, "Penguin laughs silently...");
            this.goodbye = true;
        } else if (attack < 0.43) {
            this.nextAction = new Unreality(this);
        } else if (attack < 0.58) {
            this.doubleact = true;
            this.nextAction = new SilentLaugh(this, "Nigh");
        } else if (attack < 0.63) {
            this.nextAction = new PengSun(this);
        } else if (attack < 0.68) {
            this.nextAction = new Release(this);
        } else if (attack < 0.78) {
            this.nextAction = new PengCry(this);
        } else {
            if (attack < 0.88) {
                int target = Peng2Ap.appRand.nextInt(4);
                int spell = Peng2Ap.appRand.nextInt(3);
                switch (spell) {
                    case 0: {
                        this.nextAction = new MagicSpell("Melting", ResourceManager.rm.getImg("file/eFFECTS/LargeFire.png"), 4000, DAMAGE_TYPE.FIRE, 29);
                        break;
                    }
                    case 1: {
                        this.nextAction = new MagicSpell("Freezing", ResourceManager.rm.getImg("file/eFFECTS/LargeIce.png"), 4000, DAMAGE_TYPE.ICE, 28);
                        break;
                    }
                    case 2: {
                        this.nextAction = new MagicSpell("Pulsing", ResourceManager.rm.getImg("file/eFFECTS/LargeLightning.png"), 4000, DAMAGE_TYPE.ELEC, 27);
                    }
                }
                this.nextAction.setTarget(targets.get(target));
                return 1;
            }
            this.nextAction = attack < 0.95 ? new PengPity(this) : new TheOver(this);
        }
        this.nextAction.setTarget(targets);
        return 1;
    }

    private BattleAction dubAttack(List<Fightant> targets) {
        double attack = Peng2Ap.appRand.nextDouble();
        BattleAction nextAction = null;
        if (attack < 0.2) {
            nextAction = new BasicPengAttack("Flex", this, 4000, new File("file/eFFECTS/HeavyStrike.png"), DAMAGE_TYPE.PHYS);
        } else if (attack < 0.4) {
            nextAction = new HairFlip(this);
        } else if (attack < 0.5) {
            nextAction = new Unreality(this);
        } else if (attack < 0.6) {
            nextAction = new PengSun(this);
        } else if (attack < 0.65) {
            nextAction = new Release(this);
        } else if (attack < 0.75) {
            nextAction = new PengCry(this);
        } else {
            if (attack < 0.85) {
                int target = Peng2Ap.appRand.nextInt(4);
                int spell = Peng2Ap.appRand.nextInt(3);
                switch (spell) {
                    case 0: {
                        nextAction = new MagicSpell("Melting", ResourceManager.rm.getImg("file/eFFECTS/LargeFire.png"), 4000, DAMAGE_TYPE.FIRE, 29);
                        break;
                    }
                    case 1: {
                        nextAction = new MagicSpell("Freezing", ResourceManager.rm.getImg("file/eFFECTS/LargeIce.png"), 4000, DAMAGE_TYPE.ICE, 28);
                        break;
                    }
                    case 2: {
                        nextAction = new MagicSpell("Pulsing", ResourceManager.rm.getImg("file/eFFECTS/LargeLightning.png"), 4000, DAMAGE_TYPE.ELEC, 27);
                    }
                }
                assert (nextAction != null);
                nextAction.setTarget(targets.get(target));
                return nextAction;
            }
            nextAction = attack < 0.95 ? new PengPity(this) : new TheOver(this);
        }
        nextAction.setTarget(targets);
        return nextAction;
    }

    @Override
    public Point getCenter() {
        return new Point(320, 145 + this.yOff / 100);
    }

    @Override
    public void drawSelf(Graphics g) {
        Graphics g2;
        BufferedImage hpfill = ResourceManager.rm.getImg("file/superhpfill" + (this.hpframe / 3 + 1) + ".png");
        BufferedImage hpspark = ResourceManager.rm.getImg("file/eFFECTS/sparkle" + (this.hpframe / 2 % 3 + 1) + ".png");
        if (this.scriptstate > 0 && this.scriptstate <= 99) {
            Graphics2D g2d = (Graphics2D)g.create();
            for (int y = 0; y < this.sprite.getHeight(); ++y) {
                for (int x = 0; x < this.sprite.getWidth(); ++x) {
                    if ((this.sprite.getRGB(x, y) & 0xFF0000) == 0) continue;
                    int scatterAmt = this.scriptstate * 4;
                    int rx = x + Peng2Ap.appRand.nextInt(scatterAmt) - scatterAmt / 2;
                    int ry = y + Peng2Ap.appRand.nextInt(scatterAmt) - scatterAmt / 2;
                    g2d.setColor(new Color(this.sprite.getRGB(x, y)));
                    g2d.drawLine(rx, ry, rx, ry);
                }
            }
        } else if (this.scriptstate >= 101 && this.scriptstate < 200) {
            g2 = (Graphics2D)g.create();
            int bottomcut = 0;
            int quake = 0;
            if (this.scriptstate == 103) {
                quake = Peng2Ap.appRand.nextInt(3) - 1;
                bottomcut = this.scripttimer - 150;
            }
            if (this.scriptstate == 104) {
                bottomcut = 380;
            }
            ((Graphics2D)g2).translate(quake, 0);
            g2.drawImage(this.sprite, 0, this.y + this.yOff / 100, this.sprite.getWidth(), this.sprite.getHeight() - bottomcut, 0, 0, this.sprite.getWidth(), this.sprite.getHeight() - bottomcut, null);
            float composite = (float)(this.scripttimer + 1) / 151.0f;
            if (composite > 1.0f) {
                composite = 1.0f;
            }
            ((Graphics2D)g2).setComposite(AlphaComposite.getInstance(3, composite));
            g2.drawImage(ResourceManager.rm.getImg(ResourceManager.darkPeng), 0, this.y + this.yOff / 100, this.sprite.getWidth(), this.sprite.getHeight() - bottomcut, 0, 0, this.sprite.getWidth(), this.sprite.getHeight() - bottomcut, null);
        } else {
            g2 = g.create();
            g2.setClip(null);
            float hpleft = (float)this.hp / (float)this.hpMax;
            int hpw = (int)((float)hpfill.getWidth() * hpleft);
            g2.drawImage(ResourceManager.rm.getImg(ResourceManager.finalhp), -160, 100, null);
            if (this.hp > 0) {
                g2.drawImage(hpfill, -160, 100, -160 + hpw, 100 + hpfill.getHeight(), 0, 0, hpw, hpfill.getHeight(), null);
                if (this.hp < this.hpMax) {
                    g2.drawImage(hpspark, -160 + hpw, 96, null);
                }
            }
            g.drawImage(this.sprite, 0, this.y + this.yOff / 100, null);
        }
        g2 = g.create();
        g2.setClip(null);
        for (Circ c : this.circs) {
            c.draw(g2);
        }
        for (PengDust p : this.dusts) {
            p.draw(g2);
        }
    }

    @Override
    public void drawHealth(Graphics g) {
    }

    class PengDust {
        int x;
        int y;
        int yv;
        int w;
        int h;
        int timer;

        PengDust(int xpos, int ypos) {
            this.x = xpos + Peng2Ap.appRand.nextInt(60) - 30;
            this.y = ypos * 100;
            this.yv = Peng2Ap.appRand.nextInt(250) + 350;
            this.w = Peng2Ap.appRand.nextInt(2) + 1;
            this.h = Peng2Ap.appRand.nextInt(4) + 2;
        }

        public boolean update() {
            this.y += this.yv;
            return this.timer++ > 100;
        }

        public void draw(Graphics g) {
            g.setColor(Color.decode("0x161616"));
            g.fillRect(this.x, this.y / 100, this.w, this.h);
        }
    }

    private class Circ {
        int x;
        int y;
        int xvel;
        int yvel;
        int timer;
        int rad;
        int colIndex;

        Circ(int x, int y) {
            this.x = x * 100;
            this.y = y * 100;
            this.timer = Peng2Ap.appRand.nextInt(60);
            this.rad = Peng2Ap.appRand.nextInt(20) + 5;
            int disto = Peng2Ap.appRand.nextInt(360);
            int vel = Peng2Ap.appRand.nextInt(500);
            this.xvel = (int)(Math.sin((double)disto * Math.PI / 180.0) * (double)vel);
            this.yvel = (int)(Math.cos((double)disto * Math.PI / 180.0) * (double)vel);
            this.colIndex = Peng2Ap.appRand.nextInt(circColors.length);
        }

        public void update() {
            this.x += this.xvel;
            this.y += this.yvel;
            ++this.timer;
        }

        public void draw(Graphics g) {
            if (this.timer < 120 && (this.timer < 90 || this.timer % 3 == 0)) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(circColors[this.colIndex]);
                int trueRad = this.rad + Peng2Ap.appRand.nextInt(8);
                g2d.drawOval(this.x / 100 - trueRad / 2, this.y / 100 - trueRad / 2, trueRad, trueRad);
            }
        }
    }
}

