/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2.battlers;

import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.Peng2Ap;
import ca.noxid.peng2.attack.pengs.GalacticWink;
import ca.noxid.peng2.attack.pengs.InSpace;
import ca.noxid.peng2.attack.pengs.ScatteredDreams;
import ca.noxid.peng2.attack.pengs.SpaceFantasy;
import ca.noxid.peng2.attack.pengs.Vacuum;
import ca.noxid.peng2.battlers.Fightant;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;

public class GalaxyPeng
extends Fightant {
    int xoff = 800;
    int yoff = 200;
    int disparennia = 0;
    int xv = -33;
    int yv = -50;

    public GalaxyPeng(int h, int m, int a, int d, BufferedImage s) {
        super(h, m, a, d, s);
        this.name = "Galaxy Penguin";
        this.baseDodge = 0.0539f;
    }

    @Override
    public void updateState() {
        switch (this.scriptstate) {
            case 0: {
                this.xv = this.xoff > 0 ? (this.xv -= 4) : (this.xv += 4);
                this.yv += this.yoff > 0 ? -4 : 4;
                if (this.xv > 100) {
                    this.xv = 100;
                }
                if (this.xv < -100) {
                    this.xv = -100;
                }
                if (this.yv > 100) {
                    this.yv = 100;
                }
                if (this.yv < -100) {
                    this.yv = -100;
                }
                this.xoff += this.xv;
                this.yoff += this.yv;
                break;
            }
            case 10: {
                this.xv -= this.xv > 0 ? 1 : -1;
                this.yv -= this.yv > 0 ? 1 : -1;
                this.disparennia += 2;
            }
        }
    }

    @Override
    public int chooseAttack(List<Fightant> targets, KeyUpdate update) {
        double attack = Peng2Ap.appRand.nextDouble();
        this.nextAction = attack < 0.3 ? new GalacticWink(this) : (attack < 0.5 ? new Vacuum(this) : (attack < 0.7 ? new SpaceFantasy(this) : (attack < 0.8 ? new InSpace(this) : new ScatteredDreams(this))));
        this.nextAction.setTarget(targets);
        return 1;
    }

    @Override
    public void drawHealth(Graphics g) {
        if (this.scriptstate == 0) {
            super.drawHealth(g);
        }
    }

    @Override
    public Point getCenter() {
        return new Point(360 + this.xoff / 100, 120 + this.yoff / 100);
    }

    @Override
    public void drawSelf(Graphics g) {
        int xb = this.x + this.xoff / 100;
        int yb = this.y + this.yoff / 100;
        if (this.disparennia <= 0) {
            g.drawImage(this.sprite, xb, yb, null);
        } else {
            if (this.disparennia > 600) {
                this.scriptstate = 11;
                return;
            }
            for (int i = 0; i < this.sprite.getHeight(); ++i) {
                float wfactor;
                int offset = this.disparennia - i;
                if (offset < 0) {
                    offset = 0;
                }
                if (offset > 150 && Peng2Ap.appRand.nextDouble() > 0.5 || offset > 200) continue;
                if (i % 2 == 0) {
                    offset = -offset;
                }
                if ((wfactor = (float)i * 2.0f / (float)this.disparennia) > 1.0f) {
                    wfactor = 1.0f;
                }
                Graphics2D g2d = (Graphics2D)g.create();
                float fade = 1.0f / ((float)this.disparennia / 80.0f);
                if ((double)fade > 1.0) {
                    fade = 1.0f;
                }
                if ((double)fade > 0.1) {
                    g2d.setComposite(AlphaComposite.getInstance(3, fade));
                    g2d.drawImage(this.sprite, (int)((float)(xb + offset) * wfactor), yb + i, (int)((float)(xb + this.sprite.getWidth() + offset) * wfactor), yb + i + 1, 0, i, this.sprite.getWidth(), i + 1, null);
                    continue;
                }
                this.scriptstate = 11;
            }
        }
    }
}

