/*
 * Decompiled with CFR 0.152.
 */
package ca.noxid.peng2.battlers;

import ca.noxid.peng2.BattleMenu;
import ca.noxid.peng2.Inventory;
import ca.noxid.peng2.KeyMapping;
import ca.noxid.peng2.KeyUpdate;
import ca.noxid.peng2.MenuItem;
import ca.noxid.peng2.Peng2Ap;
import ca.noxid.peng2.ResourceManager;
import ca.noxid.peng2.SoundPlayer;
import ca.noxid.peng2.attack.BattleAction;
import ca.noxid.peng2.attack.Item;
import ca.noxid.peng2.attack.players.BasicAttack;
import ca.noxid.peng2.attack.players.Block;
import ca.noxid.peng2.attack.players.DoNothing;
import ca.noxid.peng2.battlers.Fightant;
import ca.noxid.peng2.status.Confuzzled;
import ca.noxid.peng2.status.Introspected;
import ca.noxid.peng2.status.Status;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public abstract class PlayerChar
extends Fightant {
    Inventory.Item usingItem;
    ArrayList<BattleAction> specialAttacks = new ArrayList();
    BattleMenu battleMenu;
    int targetIndex;
    ArrayList<MenuItem> specialMenu = this.createSpecialMenu();
    ArrayList<MenuItem> baseMenu = this.createBaseMenu();
    BATTLEMENU_STATE bms = BATTLEMENU_STATE.NO_MENU;

    public PlayerChar(int h, int m, int a, int d, BufferedImage s) {
        super(h, m, a, d, s);
        this.battleMenu = new BattleMenu(40, 60, this);
        this.battleMenu.setOptions(this.baseMenu);
    }

    abstract ArrayList<MenuItem> createSpecialMenu();

    protected boolean removeMagic(int amt) {
        if (this.mp >= amt) {
            this.mp -= amt;
            return true;
        }
        SoundPlayer.player.playSound(5);
        return false;
    }

    private ArrayList<MenuItem> createBaseMenu() {
        ArrayList<MenuItem> rv = new ArrayList<MenuItem>();
        rv.add(new MenuItem("Attack", new Runnable(){

            @Override
            public void run() {
                PlayerChar.this.nextAction = new BasicAttack(PlayerChar.this, PlayerChar.this.name);
                PlayerChar.this.speed = 0;
                PlayerChar.this.bms = BATTLEMENU_STATE.CHOOSE_TARGET;
            }
        }));
        rv.add(new MenuItem("Special", new Runnable(){

            @Override
            public void run() {
                if (PlayerChar.this.specialMenu.size() > 0) {
                    PlayerChar.this.battleMenu.setOptions(PlayerChar.this.specialMenu);
                }
            }
        }));
        rv.add(new MenuItem("Item", new Runnable(){

            @Override
            public void run() {
                PlayerChar.this.battleMenu.setOptions(PlayerChar.this.buildItemList());
            }
        }));
        rv.add(new MenuItem("Block", new Runnable(){

            @Override
            public void run() {
                PlayerChar.this.nextAction = new Block(PlayerChar.this.name + " blocks!", PlayerChar.this);
                PlayerChar.this.speed = 1000;
                PlayerChar.this.bms = BATTLEMENU_STATE.NO_MENU;
            }
        }));
        rv.add(new MenuItem("Wait", new Runnable(){

            @Override
            public void run() {
                PlayerChar.this.nextAction = new DoNothing(PlayerChar.this.name + " waits");
                PlayerChar.this.speed = -1000;
                PlayerChar.this.bms = BATTLEMENU_STATE.NO_MENU;
            }
        }));
        rv.add(MenuItem.HELLO);
        return rv;
    }

    private List<MenuItem> buildItemList() {
        ArrayList<Inventory.Item> il = Inventory.items;
        ArrayList<MenuItem> rv = new ArrayList<MenuItem>();
        for (final Inventory.Item i : il) {
            if (i.amt <= 0) continue;
            rv.add(new MenuItem(i.name + " [ " + i.amt + "]", new Runnable(){

                @Override
                public void run() {
                    PlayerChar.this.nextAction = i.getAction();
                    if (PlayerChar.this.nextAction == null) {
                        PlayerChar.this.nextAction = new BasicAttack(PlayerChar.this, "A Jar");
                    }
                    PlayerChar.this.usingItem = i;
                    --i.amt;
                    PlayerChar.this.bms = BATTLEMENU_STATE.CHOOSE_TARGET;
                }
            }));
        }
        return rv;
    }

    public void drawMenu(Graphics g, List<Fightant> targets) {
        block0 : switch (this.bms) {
            case CHOOSE_ATTACK: {
                this.battleMenu.draw(g.create());
                break;
            }
            case CHOOSE_TARGET: {
                switch (this.nextAction.ttype) {
                    case SINGLE_ENEMY: 
                    case SINGLE_FRIEND: {
                        Point targetC = targets.get(this.targetIndex).getCenter();
                        g.drawImage(ResourceManager.rm.getImg(ResourceManager.selector), targetC.x + Peng2Ap.appRand.nextInt(6) - 23, targetC.y - 40 + Peng2Ap.appRand.nextInt(6) - 3, null);
                        break;
                    }
                    case TEAM_ENEMY: 
                    case TEAM_FRIEND: {
                        for (Fightant f : targets) {
                            if (!(f instanceof PlayerChar ^ this.targetIndex != 0)) continue;
                            Point targetC = f.getCenter();
                            g.drawImage(ResourceManager.rm.getImg(ResourceManager.selector), targetC.x + Peng2Ap.appRand.nextInt(6) - 23, targetC.y - 40 + Peng2Ap.appRand.nextInt(6) - 3, null);
                        }
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    public int chooseAttack(List<Fightant> targets, KeyUpdate update) {
        if (this.bms == BATTLEMENU_STATE.NO_MENU) {
            this.bms = BATTLEMENU_STATE.CHOOSE_ATTACK;
            this.battleMenu.setOptions(this.baseMenu);
        }
        block0 : switch (this.bms) {
            case CHOOSE_ATTACK: {
                if (this.usingItem != null) {
                    ++this.usingItem.amt;
                    this.usingItem = null;
                }
                this.battleMenu.update(update);
                if (update.pressed(KeyMapping.GAMEKEYS.KEY_LEFT)) {
                    this.bms = BATTLEMENU_STATE.NO_MENU;
                    return 2;
                }
                if (this.bms != BATTLEMENU_STATE.CHOOSE_TARGET) break;
                this.initTarget(this.nextAction.ttype);
                break;
            }
            case CHOOSE_TARGET: {
                if (update.pressed(KeyMapping.GAMEKEYS.KEY_MENU)) {
                    this.bms = BATTLEMENU_STATE.CHOOSE_ATTACK;
                    SoundPlayer.player.playSound(5);
                    return 0;
                }
                switch (this.nextAction.ttype) {
                    case SINGLE_ENEMY: 
                    case SINGLE_FRIEND: {
                        for (Status s : this.getStatuses()) {
                            if (s instanceof Confuzzled) {
                                this.nextAction.setTarget(targets.get(Peng2Ap.appRand.nextInt(targets.size())));
                                this.bms = BATTLEMENU_STATE.NO_MENU;
                                return 1;
                            }
                            if (!(s instanceof Introspected) || this.nextAction instanceof BasicAttack || this.nextAction instanceof Block || this.nextAction instanceof Item) continue;
                            this.nextAction.setTarget(this);
                            this.bms = BATTLEMENU_STATE.NO_MENU;
                            return 1;
                        }
                        break;
                    }
                    case TEAM_ENEMY: 
                    case TEAM_FRIEND: {
                        for (Status s : this.getStatuses()) {
                            if (s instanceof Confuzzled) {
                                if (Peng2Ap.appRand.nextBoolean()) {
                                    this.nextAction.setTarget(targets.get(0), targets.get(1), targets.get(2), targets.get(3));
                                } else {
                                    this.nextAction.setTarget(targets.get(4));
                                }
                                this.bms = BATTLEMENU_STATE.NO_MENU;
                                return 1;
                            }
                            if (!(s instanceof Introspected) || this.nextAction instanceof BasicAttack || this.nextAction instanceof Block || this.nextAction instanceof Item) continue;
                            this.nextAction.setTarget(targets.get(0), targets.get(1), targets.get(2), targets.get(3));
                            this.bms = BATTLEMENU_STATE.NO_MENU;
                            return 1;
                        }
                        break;
                    }
                }
                if (this.nextAction.ttype == BattleAction.TARGET_TYPE.AUTOMATIC) {
                    this.nextAction.setTarget(targets);
                    this.bms = BATTLEMENU_STATE.NO_MENU;
                    break;
                }
                if (update.pressed(KeyMapping.GAMEKEYS.KEY_UP, KeyMapping.GAMEKEYS.KEY_RIGHT)) {
                    this.incrementTarget(targets.size());
                    SoundPlayer.player.playSound(3);
                }
                if (update.pressed(KeyMapping.GAMEKEYS.KEY_DOWN, KeyMapping.GAMEKEYS.KEY_LEFT)) {
                    this.decrement_target(targets.size());
                    SoundPlayer.player.playSound(3);
                }
                if (!update.pressed(KeyMapping.GAMEKEYS.KEY_JUMP)) break;
                this.bms = BATTLEMENU_STATE.NO_MENU;
                SoundPlayer.player.playSound(4);
                switch (this.nextAction.ttype) {
                    case SINGLE_ENEMY: 
                    case SINGLE_FRIEND: {
                        this.nextAction.setTarget(targets.get(this.targetIndex));
                        break block0;
                    }
                    case TEAM_ENEMY: 
                    case TEAM_FRIEND: {
                        if (this.targetIndex == 0) {
                            this.nextAction.setTarget(targets.get(0), targets.get(1), targets.get(2), targets.get(3));
                            break block0;
                        }
                        this.nextAction.setTarget(targets.get(4));
                        break block0;
                    }
                }
                break;
            }
        }
        if (this.bms == BATTLEMENU_STATE.NO_MENU) {
            return 1;
        }
        return 0;
    }

    private void decrement_target(int n) {
        switch (this.nextAction.ttype) {
            case SINGLE_ENEMY: 
            case SINGLE_FRIEND: {
                --this.targetIndex;
                if (this.targetIndex >= 0) break;
                this.targetIndex = n - 1;
                break;
            }
            case TEAM_ENEMY: 
            case TEAM_FRIEND: {
                this.targetIndex ^= 1;
                break;
            }
        }
    }

    private void incrementTarget(int n) {
        switch (this.nextAction.ttype) {
            case SINGLE_ENEMY: 
            case SINGLE_FRIEND: {
                ++this.targetIndex;
                if (this.targetIndex < n) break;
                this.targetIndex = 0;
                break;
            }
            case TEAM_ENEMY: 
            case TEAM_FRIEND: {
                this.targetIndex ^= 1;
                break;
            }
        }
    }

    @Override
    public void rebase() {
        super.rebase();
        this.battleMenu.resetCursor();
        this.battleMenu.clearDisabledOptions();
        this.usingItem = null;
    }

    public void initTarget(BattleAction.TARGET_TYPE type) {
        switch (type) {
            case SINGLE_ENEMY: {
                this.targetIndex = 4;
                break;
            }
            case SINGLE_FRIEND: {
                this.targetIndex = 0;
                break;
            }
            case TEAM_ENEMY: {
                this.targetIndex = 1;
                break;
            }
            case TEAM_FRIEND: {
                this.targetIndex = 0;
                break;
            }
        }
    }

    @Override
    public void disableMenu(int ... ids) {
        this.battleMenu.disable(ids);
    }

    static enum BATTLEMENU_STATE {
        CHOOSE_ATTACK,
        CHOOSE_TARGET,
        NO_MENU;

    }
}

